 ; Chgtext - rudimentary text editor.
 (DEFUN C:CHGTEXT (/ chm chnum p osp cont osl nsl ns l n e chf s as sl st si)
  (setvar "cmdecho" 0)
  (command "undo" "M")
  (setq chm 0)
  (setq chnum 0)
  (if (setq p (ssget))
     (progn
          (if (and (= (type os) 'STR) (/= os ""))
              (progn
                   (setq osp (getstring t (strcat "\nOld string <" os ">: ")))
                   (if (/= osp "") (setq os osp)))
              (while (= (setq os (getstring t "\nOld string: ")) "")
                     (if (= os "") (princ "Null input invalid"))))
          (setq osl (strlen os))
          (setq nsl (strlen (setq ns (getstring t "\nNew string: "))))
          (setq l 0)
          (setq n (sslength p))
          (while (< l n)
                 (if (= "TEXT" (cdr (assoc 0 (setq e (entget (ssname p l))))))
                     (progn
                          (setq chf nil si 1)
                          (setq s (cdr (setq as (assoc 1 e))))
                          (while (= osl (setq sl (strlen
                                                 (setq st (substr s si osl)))))
                                 (if (= st os)
                                     (progn
                                          (setq s (strcat (substr s 1 (1- si))
                                                     ns (substr s (+ si osl))))
                                          (setq chf t)
                                          (setq chnum (1+ chnum))
                                          (setq si (+ si nsl)))
                                     (setq si (1+ si))))
                          (if chf
                             (progn
                                  (setq e (subst (cons 1 s) as e))
                                  (entmod e)
                                  (setq chm (1+ chm))))))
                 (setq l (1+ l)))
          (if (< 0 chm)
              (write-line (strcat "Changed " (itoa chnum)
                                  " instance" (if (= chnum 1) "" "s")
                                  " in " (itoa chm)
                                  " line" (if (= chm 1) "." "s.")))
              (write-line "No changes made."))))
 (princ))